
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x_w = m.addVar(lb=0, name="wood_investment")
x_b = m.addVar(lb=0, name="bamboo_investment")

# Set the objective function to maximize average return
m.setObjective(0.07*x_w + 0.03*x_b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_w + x_b == 10000, "total_budget")
m.addConstr(x_w >= 4*x_b, "wood_at_least_four_times_bamboo")
m.addConstr(x_w <= 7000, "max_wood_investment")

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal wood investment: $", x_w.x)
    print("Optimal bamboo investment: $", x_b.x)
else:
    print("No optimal solution found. The problem may be infeasible.")
