
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    W = model.addVar(lb=0, ub=10000, name="Wood_Investment")
    B = model.addVar(lb=0, ub=10000, name="Bamboo_Investment")

    # Objective: Maximize 0.07W + 0.03B
    model.setObjective(0.07 * W + 0.03 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(W >= 4 * B, name="Wood_Bamboo_Ratio")
    model.addConstr(W <= 7000, name="Wood_Investment_Max")
    model.addConstr(W + B == 10000, name="Total_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in wood industry: ${W.varValue:.2f}")
        print(f"Optimal investment in bamboo industry: ${B.varValue:.2f}")
        print(f"Max return: ${0.07 * W.varValue + 0.03 * B.varValue:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_investment_problem()
