
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("burrito_optimization")

# Create variables
x = m.addVar(lb=0, name="beans")  # Units of beans
y = m.addVar(lb=0, name="onions") # Units of onions

# Set objective function
m.setObjective(6*x + 8*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x + 2*y >= 110, "spice_constraint")
m.addConstr(3*x + 6*y >= 80, "flavor_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Units of beans: {x.x:.2f}")
    print(f"Units of onions: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

