
from gurobipy import *

# Create a new model
m = Model("Burrito_Optimization")

# Define the decision variables
x_b = m.addVar(name="beans", lb=0)
x_o = m.addVar(name="onions", lb=0)

# Set the objective function
m.setObjective(6*x_b + 8*x_o, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x_b + 2*x_o >= 110, name="spice_constraint")
m.addConstr(3*x_b + 6*x_o >= 80, name="flavor_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beans: {x_b.x}")
    print(f"Onions: {x_o.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
