
import gurobi

def solve_burrito_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    B = model.addVar(lb=0, name="Beans")  # Units of beans
    O = model.addVar(lb=0, name="Onions")  # Units of onions

    # Objective function: Minimize cost
    model.setObjective(6*B + 8*O, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10*B + 2*O >= 110, name="Spice_Requirement")  # Spice requirement
    model.addConstr(3*B + 6*O >= 80, name="Flavor_Requirement")  # Flavor requirement

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Minimum cost: ${model.objVal:.2f}")
        print(f"Beans: {B.x:.2f} units")
        print(f"Onions: {O.x:.2f} units")
    else:
        print("The problem is infeasible.")

solve_burrito_problem()
