
from gurobipy import *

# Create a model
m = Model("Cat_Food_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cat_food_packets")
y = m.addVar(vtype=GRB.CONTINUOUS, name="tuna_cans")

# Define the objective function
m.setObjective(12*x + 7*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 7*y >= 700, "carbohydrates")
m.addConstr(15*x + 12*y >= 1100, "vitamins")
m.addConstr(12*x + 15*y >= 900, "protein")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x.x} packets of cat food and {y.x} cans of tuna.")
    print(f"Total cost: ${12*x.x + 7*y.x}")
else:
    print("No optimal solution found.")
