
import gurobi

def solve_cat_shelter_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="cat_food_packets", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="cans_of_tuna", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(12*x + 7*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x + 7*y >= 700, name="carbohydrates_requirement")
    model.addConstr(15*x + 12*y >= 1100, name="vitamins_requirement")
    model.addConstr(12*x + 15*y >= 900, name="protein_requirement")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Cost: {model.objVal}")
        print(f"Packets of cat food: {x.varValue}")
        print(f"Cans of tuna: {y.varValue}")
    else:
        print("No optimal solution found.")

solve_cat_shelter_problem()
