
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Motherboard_Production")

    # Create variables
    x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x") # 1st gen motherboards
    y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="y") # 2nd gen motherboards


    # Set objective
    m.setObjective(100*x + 125*y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x + 6*y <= 450, "Silicon")
    m.addConstr(20*x + 30*y <= 900, "Assembly")
    m.addConstr(30*x + 40*y <= 500, "Soldering")
    m.addConstr(x >= 6, "Min_1st_Gen")
    m.addConstr(y >= 7, "Min_2nd_Gen")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Produce {x.x:.2f} 1st generation motherboards")
        print(f"Produce {y.x:.2f} 2nd generation motherboards")
        print(f"Maximum Profit: ${m.objVal:.2f}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
