
from gurobipy import *

# Create a new model
m = Model("Motherboard_Production")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="First_Gen_Motherboards", lb=6)  # Minimum of 6 first gen motherboards
x2 = m.addVar(vtype=GRB.INTEGER, name="Second_Gen_Motherboards", lb=7)  # Minimum of 7 second gen motherboards

# Objective function: Maximize profit
m.setObjective(100*x1 + 125*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x1 + 6*x2 <= 450, name="Silicon_Constraint")
m.addConstr(20*x1 + 30*x2 <= 900, name="Assembly_Time_Constraint")
m.addConstr(30*x1 + 40*x2 <= 500, name="Soldering_Time_Constraint")

# Solve the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective (Max Profit): {m.objVal}")

