
import gurobi

def solve_motherboard_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=6, vtype=gurobi.GRB.INTEGER, name="1st_generation_motherboards")
    x2 = model.addVar(lb=7, vtype=gurobi.GRB.INTEGER, name="2nd_generation_motherboards")

    # Objective function: Maximize profit
    model.setObjective(100*x1 + 125*x2, gurobi.GRB.MAXIMIZE)

    # Silicon constraint
    model.addConstr(4*x1 + 6*x2 <= 450, name="silicon_constraint")

    # Assembly time constraint
    model.addConstr(20*x1 + 30*x2 <= 900, name="assembly_time_constraint")

    # Soldering time constraint
    model.addConstr(30*x1 + 40*x2 <= 500, name="soldering_time_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Produce {x1.varValue} 1st generation motherboards and {x2.varValue} 2nd generation motherboards.")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_motherboard_production()
