
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Toms_Florist")

# Create variables
s = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sunflowers") # Number of sunflower bouquets
r = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="roses") # Number of rose bouquets

# Set objective function
m.setObjective(7*s + 12*r, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*s + 5*r <= 1200, "clipping_time")
m.addConstr(3*s + 7*r <= 800, "packaging_time")
m.addConstr(s >= 30, "min_sunflowers")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of sunflower bouquets: {s.x:.2f}")
    print(f"Number of rose bouquets: {r.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

