
from gurobipy import *

# Create a new model
model = Model("Tom's Florist")

# Add decision variables
S = model.addVar(vtype=GRB.CONTINUOUS, name="Sunflowers", lb=30)  # Minimum of 30 sunflowers
R = model.addVar(vtype=GRB.CONTINUOUS, name="Roses", lb=0)

# Set the objective function
model.setObjective(7*S + 12*R, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*S + 5*R <= 1200, "Clipping Time")
model.addConstr(3*S + 7*R <= 800, "Packaging Time")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Sunflowers: {S.x}, Roses: {R.x}")
    print(f"Profit: ${7*S.x + 12*R.x:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible or unbounded.")

