
import gurobi

def solve_florist_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(lb=0, name="Sunflowers")
    R = model.addVar(lb=0, name="Roses")

    # Objective function: Maximize profit
    model.setObjective(7 * S + 12 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * S + 5 * R <= 1200, name="Clipping_Time")
    model.addConstr(3 * S + 7 * R <= 800, name="Packaging_Time")
    model.addConstr(S >= 30, name="Min_Sunflowers")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Sunflowers = {S.varValue}, Roses = {R.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_florist_problem()
