
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("train_profit")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular")

# Set objective
m.setObjective(1200*x + 700*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "total_seats")
m.addConstr(x >= 50, "min_first_class")
m.addConstr(y >= 3*x, "regular_preference")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"First-class seats: {x.x}")
    print(f"Regular seats: {y.x}")
else:
    print("Infeasible or unbounded")

