
from gurobipy import *

# Create a new model
m = Model("Train_Seat_Allocation")

# Define variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="first_class_seats")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_seats")

# Objective function: Maximize profit
m.setObjective(1200*x + 700*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 300, "total_seats")
m.addConstr(x >= 50, "first_class_minimum")
m.addConstr(y >= 3*x, "regular_to_first_class_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"First-class seats: {x.x}")
    print(f"Regular seats: {y.x}")
    print(f"Total profit: ${1200*x.x + 700*y.x}")
else:
    print("No optimal solution found")
