
import gurobi

def solve_train_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="first_class_seats")
    y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="regular_seats")

    # Objective function: Maximize profit
    model.setObjective(1200*x + 700*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 300, name="total_seats")
    model.addConstr(x >= 50, name="min_first_class_seats")
    model.addConstr(y >= 3*x, name="preference_regular_seats")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: First-class seats = {x.varValue}, Regular seats = {y.varValue}")
        print(f"Maximum Profit: ${1200*x.varValue + 700*y.varValue}")
    else:
        print("The model is infeasible")

solve_train_seating_problem()
