
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Hardware_Manufacturing")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="CPUs")  # Integer number of CPUs
y = model.addVar(vtype=GRB.INTEGER, name="GPUs")  # Integer number of GPUs

# Set the objective function
model.setObjective(300*x + 500*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 90*y <= 2000, "Wiring_Constraint")
model.addConstr(50*x + 40*y <= 2500, "Soldering_Constraint")


# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of CPUs to manufacture: {x.x}")
    print(f"Number of GPUs to manufacture: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

