
from gurobipy import *

# Create a new model
m = Model("Hardware_Manufacturer")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="CPUs")
y = m.addVar(vtype=GRB.INTEGER, name="GPUs")

# Set the objective function to maximize profit
m.setObjective(300*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 90*y <= 2000, "Wiring_Constraint")
m.addConstr(50*x + 40*y <= 2500, "Soldering_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"CPUs to produce: {x.x}")
    print(f"GPUs to produce: {y.x}")
    print(f"Maximum profit: ${300*x.x + 500*y.x}")
else:
    print("No optimal solution found")
