
import gurobipy as gp

# Create a new model
model = gp.Model("cpu_gpu_production")

# Define the decision variables
x = model.addVar(name="cpu", lb=0, vtype=gp.GRB.INTEGER)  # number of CPUs to produce
y = model.addVar(name="gpu", lb=0, vtype=gp.GRB.INTEGER)  # number of GPUs to produce

# Define the objective function
model.setObjective(300*x + 500*y, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(30*x + 90*y <= 2000, name="wiring_time_constraint")
model.addConstr(50*x + 40*y <= 2500, name="soldering_time_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of CPUs to produce: {x.varValue}")
    print(f"Number of GPUs to produce: {y.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
