
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("sign_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="neon_signs")  # Neon signs
y = m.addVar(vtype=GRB.CONTINUOUS, name="metal_signs")  # Metal signs

# Set objective function
m.setObjective(200*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 2*y <= 950, "crafting_constraint")
m.addConstr(2*x + 1.5*y <= 400, "installation_constraint")
m.addConstr(x >= 0, "neon_nonnegativity")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "metal_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of neon signs: {x.x}")
    print(f"Number of metal signs: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

