
from gurobipy import *

# Create a model
m = Model("Sign_Company_Profit_Optimization")

# Define the decision variables
N = m.addVar(lb=0, vtype=GRB.INTEGER, name="Neon_Signs")
M = m.addVar(lb=0, vtype=GRB.INTEGER, name="Metal_Signs")

# Set the objective function: Maximize profit
m.setObjective(200*N + 100*M, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*N + 2*M <= 950, "Crafting_Time_Constraint")
m.addConstr(2*N + 1.5*M <= 400, "Installation_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {N.varName} = {N.x}, {M.varName} = {M.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
