
import gurobi

def solve_sign_company_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    N = model.addVar(lb=0, name="Neon Signs")
    M = model.addVar(lb=0, name="Metal Signs")

    # Define the objective function
    model.setObjective(200 * N + 100 * M, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3 * N + 2 * M <= 950, name="Crafting Hours")
    model.addConstr(2 * N + 1.5 * M <= 400, name="Installation Hours")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Neon Signs = {N.varValue:.2f}, Metal Signs = {M.varValue:.2f}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

# Run the function
solve_sign_company_problem()
