
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("calculator_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="scientific")
y = m.addVar(vtype=GRB.CONTINUOUS, name="graphing")

# Set objective
m.setObjective(6 * x + 8 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x + 4 * y <= 100, "silicon")
m.addConstr(4 * x + 6 * y <= 200, "plastic")
m.addConstr(x + 2 * y <= 50, "silver")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of scientific calculators: {x.x}")
    print(f"Number of graphing calculators: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

