
from gurobipy import *

# Create a new model
m = Model("Calculator_Production")

# Define the decision variables
x_s = m.addVar(name="scientific_calculators", lb=0)
x_g = m.addVar(name="graphing_calculators", lb=0)

# Set the objective function
m.setObjective(6*x_s + 8*x_g, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x_s + 4*x_g <= 100, name="silicon_constraint")
m.addConstr(4*x_s + 6*x_g <= 200, name="plastic_constraint")
m.addConstr(x_s + 2*x_g <= 50, name="silver_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Scientific Calculators: {x_s.x}")
    print(f"Graphing Calculators: {x_g.x}")
    print(f"Maximum Profit: ${6*x_s.x + 8*x_g.x:.2f}")
else:
    print("No optimal solution found.")

