
import gurobi

def solve_calculator_production():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x_s = model.addVar(name="scientific_calculators", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_g = model.addVar(name="graphing_calculators", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define objective function
    model.setObjective(6 * x_s + 8 * x_g, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * x_s + 4 * x_g <= 100, name="silicon_constraint")
    model.addConstr(4 * x_s + 6 * x_g <= 200, name="plastic_constraint")
    model.addConstr(x_s + 2 * x_g <= 50, name="silver_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: ${model.objVal:.2f}")
        print(f"Scientific calculators: {x_s.x:.2f}")
        print(f"Graphing calculators: {x_g.x:.2f}")
    else:
        print("The problem is infeasible.")

solve_calculator_production()
