
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Ferris_Wheel_Profit")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="premium_tickets") # Integer number of premium tickets
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets") # Integer number of regular tickets


# Set objective function
model.setObjective(50*x + 30*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 250, "capacity")
model.addConstr(x >= 50, "min_premium")
model.addConstr(y >= 3*x, "regular_preference")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal}")
    print(f"Premium Tickets: {x.x}")
    print(f"Regular Tickets: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

