
from gurobipy import *

# Create a new model
m = Model("Ferris_Wheel_Optimization")

# Define variables
P = m.addVar(lb=50, vtype=GRB.INTEGER, name="Premium_Tickets")
R = m.addVar(vtype=GRB.INTEGER, name="Regular_Tickets")

# Objective function: Maximize profit
m.setObjective(50*P + 30*R, GRB.MAXIMIZE)

# Constraints
m.addConstr(P + R <= 250, "Capacity_Constraint")
m.addConstr(R >= 3*P, "Ticket_Preference_Constraint")

# Solve the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium Tickets: {P.x}")
    print(f"Regular Tickets: {R.x}")
    print(f"Maximum Profit: ${50*P.x + 30*R.x:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible.")
