
import gurobi

def ferris_wheel_ticket_sales():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    P = model.addVar(lb=50, name="Premium_Tickets")  # At least 50 premium tickets
    R = model.addVar(name="Regular_Tickets")

    # Objective function: Maximize profit
    model.setObjective(50 * P + 30 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(P + R <= 250, name="Ferris_Wheel_Capacity")  # Capacity constraint
    model.addConstr(R >= 3 * P, name="Regular_vs_Premium")  # Preference constraint

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Premium Tickets: {P.varValue}")
        print(f"Regular Tickets: {R.varValue}")
        print(f"Max Profit: {50 * P.varValue + 30 * R.varValue}")
    else:
        print("The model is infeasible.")

# Run the function
ferris_wheel_ticket_sales()
