
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("apple_mix")

# Create decision variables
g = model.addVar(lb=0, name="green_apples")
r = model.addVar(lb=0, name="red_apples")

# Set objective function
model.setObjective(9*g + 7*r, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.05*g + 0.25*r >= 12, "sugar_constraint")
model.addConstr(0.16*g + 0.08*r >= 5, "fiber_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Green apples: {g.x:.2f} kg")
    print(f"Red apples: {r.x:.2f} kg")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

