
from gurobipy import *

# Create a new model
m = Model("Apple_Pie_Filling")

# Define the variables
x_g = m.addVar(lb=0, name="green_apples")  # Amount of green apples in kg
x_r = m.addVar(lb=0, name="red_apples")    # Amount of red apples in kg

# Set the objective function: Minimize the total cost
m.setObjective(9*x_g + 7*x_r, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.05*x_g + 0.25*x_r >= 12, name="sugar_constraint")  # Minimum sugar requirement
m.addConstr(0.16*x_g + 0.08*x_r >= 5, name="fiber_constraint")   # Minimum fiber requirement

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Minimum cost: $", m.objVal)
    print("Green apples to use (kg): ", x_g.x)
    print("Red apples to use (kg): ", x_r.x)
else:
    print("The model is infeasible")
