
import gurobi

def solve_pie_filling_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    G = model.addVar(lb=0, name="Green_Apples")  # kg
    R = model.addVar(lb=0, name="Red_Apples")    # kg

    # Objective: Minimize the total cost
    model.setObjective(9*G + 7*R, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.05*G + 0.25*R >= 12, name="Sugar_Requirement")
    model.addConstr(0.16*G + 0.08*R >= 5, name="Fiber_Requirement")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Green Apples: {G.varValue} kg")
        print(f"Red Apples: {R.varValue} kg")
        print(f"Minimum Cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_pie_filling_problem()
