
import gurobipy as gp

# Create a new model
model = gp.Model("lunch_optimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="meat_lunches")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="veggie_lunches")

# Set objective function
model.setObjective(8*x + 6*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 4*y <= 500, "prep_time")
model.addConstr(3*x + 5*y <= 400, "packaging_time")
model.addConstr(x >= 0, "meat_nonneg")
model.addConstr(y >= 0, "veggie_nonneg")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of meat lunches: {x.x}")
    print(f"Number of veggie lunches: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

