
from gurobipy import *

# Create a new model
m = Model("Packaged_Lunches")

# Decision Variables
M = m.addVar(vtype=GRB.CONTINUOUS, name="Meat_Lunches", lb=0)
V = m.addVar(vtype=GRB.CONTINUOUS, name="Veggie_Lunches", lb=0)

# Objective Function: Maximize Profit
m.setObjective(8*M + 6*V, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*M + 4*V <= 500, name="Preparation_Time")
m.addConstr(3*M + 5*V <= 400, name="Packaging_Time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {M.varName} = {M.x}, {V.varName} = {V.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")

