
import gurobi

# Create a new model
m = gurobi.Model()

# Define the decision variables
M = m.addVar(lb=0, name="Meat_Lunches")
V = m.addVar(lb=0, name="Veggie_Lunches")

# Define the objective function
m.setObjective(8 * M + 6 * V, gurobi.GRB.MAXIMIZE)

# Add the preparation time constraint
m.addConstr(5 * M + 4 * V <= 500, name="Preparation_Time")

# Add the packaging time constraint
m.addConstr(3 * M + 5 * V <= 400, name="Packaging_Time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of meat lunches: {M.varValue}")
    print(f"Number of veggie lunches: {V.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
