
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Farm Allocation")

# Create variables
x = m.addVar(lb=0, name="pumpkins") # Acres of pumpkins
y = m.addVar(lb=0, name="potatoes") # Acres of potatoes

# Set objective function
m.setObjective(150*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x + 0.9*y <= 12, "tractor")
m.addConstr(0.6*x + 0.5*y <= 12, "plow")
m.addConstr(0.4*x + 0.3*y <= 12, "combine")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal:.2f}")
    print(f"Acres of Pumpkins: {x.x:.2f}")
    print(f"Acres of Potatoes: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

