
from gurobipy import *

# Create a model
m = Model("Nolan_Farming")

# Define the variables
x_p = m.addVar(lb=0, name="pumpkin_acres")
x_t = m.addVar(lb=0, name="potato_acres")

# Set the objective function
m.setObjective(150*x_p + 200*x_t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x_p + 0.9*x_t <= 12, "tractor_time")
m.addConstr(0.6*x_p + 0.5*x_t <= 12, "plow_time")
m.addConstr(0.4*x_p + 0.3*x_t <= 12, "combine_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pumpkin acres: {x_p.x}")
    print(f"Potato acres: {x_t.x}")
    print(f"Total revenue: ${150*x_p.x + 200*x_t.x:.2f}")
else:
    print("No optimal solution found")
