
import gurobipy as gp

# Create a new model
model = gp.Model("NolanFarmingProblem")

# Define decision variables
x_p = model.addVar(name="pumpkin_acres", lb=0, ub=gp.GRB.INFINITY)
x_t = model.addVar(name="potato_acres", lb=0, ub=gp.GRB.INFINITY)

# Objective function: Maximize revenue
model.setObjective(150*x_p + 200*x_t, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(0.5*x_p + 0.9*x_t <= 12, name="tractor_usage")
model.addConstr(0.6*x_p + 0.5*x_t <= 12, name="plow_usage")
model.addConstr(0.4*x_p + 0.3*x_t <= 12, name="combine_usage")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of pumpkins: {x_p.varValue}")
    print(f"Optimal acres of potatoes: {x_t.varValue}")
    print(f"Max revenue: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
