
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("network_design")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="star")
y = m.addVar(vtype=GRB.INTEGER, name="circle")
z = m.addVar(vtype=GRB.INTEGER, name="snowflake")

# Set objective function
m.setObjective(2231*x + 3434*y + 8621*z, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x + 20*y + 323*z <= 3000, "workstation_constraint")
m.addConstr(10*x + 12*y + 122*z <= 400, "server_constraint")
m.addConstr(2*x + 5*y + 41*z <= 200, "switch_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Star Layouts (x): {x.x}")
    print(f"Number of Circle Layouts (y): {y.x}")
    print(f"Number of Snowflake Layouts (z): {z.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

