
from gurobipy import *

# Create a new model
m = Model("Network Layout Optimization")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="star_layouts")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="circle_layouts")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="snowflake_layouts")

# Define the objective function
m.setObjective(2231*x1 + 3434*x2 + 8621*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x1 + 20*x2 + 323*x3 <= 3000, "workstations")
m.addConstr(10*x1 + 12*x2 + 122*x3 <= 400, "servers")
m.addConstr(2*x1 + 5*x2 + 41*x3 <= 200, "switches")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Star layouts: {x1.x}")
    print(f"Circle layouts: {x2.x}")
    print(f"Snowflake layouts: {x3.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")

