
import gurobipy as gp

# Create a new model
m = gp.Model("layout_optimization")

# Define the decision variables
x1 = m.addVar(name="star_layouts", lb=0, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="circle_layouts", lb=0, vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="snowflake_layouts", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2231*x1 + 3434*x2 + 8621*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(40*x1 + 20*x2 + 323*x3 <= 3000, name="workstations")
m.addConstr(10*x1 + 12*x2 + 122*x3 <= 400, name="servers")
m.addConstr(2*x1 + 5*x2 + 41*x3 <= 200, name="switches")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Star layouts: {x1.varValue}")
    print(f"Circle layouts: {x2.varValue}")
    print(f"Snowflake layouts: {x3.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
