
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("DetergentOptimization")

# Create decision variables
x = model.addVar(lb=0, name="Fruity_Loop")
y = model.addVar(lb=0, name="Passion_Cook")

# Set objective function
model.setObjective(6*x + 5*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.10*x + 0.05*y >= 20, "Soap_Constraint")
model.addConstr(0.06*x + 0.10*y >= 15, "Citric_Acid_Constraint")


# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Fruity Loop Production: {x.x:.2f} kg")
    print(f"Passion Cook Production: {y.x:.2f} kg")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

