
from gurobipy import *

# Create a new model
m = Model("Detergent_Production")

# Define the decision variables
x = m.addVar(lb=0, name="Fruity_Loop")
y = m.addVar(lb=0, name="Passion_Cook")

# Define the objective function: minimize total cost
m.setObjective(6*x + 5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.10*x + 0.05*y >= 20, "Soap_Requirement")
m.addConstr(0.06*x + 0.10*y >= 15, "Citric_Acid_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Produce {x.x} kg of Fruity Loop")
    print(f"Produce {y.x} kg of Passion Cook")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found. The problem might be infeasible.")

