
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Fruity_Loop", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Passion_Cook", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize total cost
    model.setObjective(6 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.10 * x1 + 0.05 * x2 >= 20, name="soap_requirement")
    model.addConstr(0.06 * x1 + 0.10 * x2 >= 15, name="citric_acid_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Fruity Loop = {x1.varValue} kg, Passion Cook = {x2.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_problem()
