
import gurobipy as gp

# Create a new model
model = gp.Model("ShippingOptimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="containers")
y = model.addVar(vtype=gp.GRB.INTEGER, name="planes")

# Set the objective function
model.setObjective(1000*x + 800*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5000*x + 6000*y <= 20000, "budget")
model.addConstr(x <= y, "shipping_delay")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of containers (x): {x.x}")
    print(f"Number of planes (y): {y.x}")
    print(f"Total products shipped: {1000*x.x + 800*y.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

