
from gurobipy import *

# Create a new model
m = Model("Shipping Optimization")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="shipping_containers")
y = m.addVar(vtype=GRB.INTEGER, name="cargo_planes")

# Set the objective function to maximize the total number of products sent
m.setObjective(1000*x + 800*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5000*x + 6000*y <= 20000, "budget_constraint")
m.addConstr(x <= y, "shipping_delay_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of shipping containers: {x.x}")
    print(f"Number of cargo planes: {y.x}")
    print(f"Total number of products sent: {1000*x.x + 800*y.x}")
else:
    print("No optimal solution found")
