
import gurobi

def solve_shipping_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="containers")
    y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="planes")

    # Objective function: maximize the total number of products sent
    model.setObjective(1000*x + 800*y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(5000*x + 6000*y <= 20000, name="budget_constraint")

    # Container and plane constraint
    model.addConstr(x <= y, name="container_plane_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: containers = {x.varValue}, planes = {y.varValue}")
        print(f"Maximum products sent: {1000*x.varValue + 800*y.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_shipping_problem()
