
import gurobipy as gp

# Create a new model
m = gp.Model("knitting_problem")

# Create variables
toques = m.addVar(vtype=gp.GRB.INTEGER, name="toques")
scarfs = m.addVar(vtype=gp.GRB.INTEGER, name="scarfs")

# Set objective function
m.setObjective(5 * toques + 7 * scarfs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * toques + 5 * scarfs <= 200, "yarn_constraint")
m.addConstr(30 * toques + 40 * scarfs <= 1800, "time_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of toques to knit: {toques.x}")
    print(f"Number of scarfs to knit: {scarfs.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

