
from gurobipy import *

# Create a new model
m = Model("Knitting_Optimization")

# Define variables
T = m.addVar(name="Toques", vtype=GRB.INTEGER, lb=0)
S = m.addVar(name="Scarves", vtype=GRB.INTEGER, lb=0)

# Set the objective function: Maximize profit
m.setObjective(5*T + 7*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*T + 5*S <= 200, name="Yarn_Constraint")
m.addConstr(30*T + 40*S <= 1800, name="Time_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {T.varName} = {T.x}, {S.varName} = {S.x}")
    print(f"Maximum profit: ${5*T.x + 7*S.x}")
else:
    print("No optimal solution found")
