
import gurobi as gp

# Create a new model
model = gp.Model("Knitting_Problem")

# Define variables
T = model.addVar(name="Toques", lb=0, vtype=gp.GRB.INTEGER)  # Number of toques
S = model.addVar(name="Scarfs", lb=0, vtype=gp.GRB.INTEGER)  # Number of scarfs

# Objective function: Maximize profit
model.setObjective(5 * T + 7 * S, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(3 * T + 5 * S <= 200, name="Yarn_Constraint")  # Yarn constraint
model.addConstr(30 * T + 40 * S <= 1800, name="Time_Constraint")  # Time constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Toques: {T.varValue}, Scarfs: {S.varValue}")
    print(f"Max Profit: ${5 * T.varValue + 7 * S.varValue}")
else:
    print("No optimal solution found.")
