
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("MovieTheatreSeating")

# Create decision variables
m = model.addVar(vtype=GRB.INTEGER, name="m") # moving seats
r = model.addVar(vtype=GRB.INTEGER, name="r") # regular seats

# Set objective function
model.setObjective(15*m + 10*r, GRB.MAXIMIZE)

# Add constraints
model.addConstr(m + r <= 100, "Capacity")
model.addConstr(m >= 15, "MinMovingSeats")
model.addConstr(r >= 3*m, "RegularSeatPreference")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of moving seats to sell: {m.x}")
    print(f"Number of regular seats to sell: {r.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

